/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.recipe.type;

import gloridifice.watersource.common.item.StrainerBlockItem;
import gloridifice.watersource.common.item.WaterBagItem;
import gloridifice.watersource.helper.FluidHelper;
import gloridifice.watersource.registry.BlockRegistry;
import gloridifice.watersource.registry.FluidRegistry;
import gloridifice.watersource.registry.ItemRegistry;
import gloridifice.watersource.registry.RecipeSerializersRegistry;
import java.util.ArrayList;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PurifiedWaterBagRecipe
extends SpecialRecipe {
    protected Fluid fluid = (Fluid)FluidRegistry.PURIFIED_WATER.get();
    protected ResourceLocation strainerTag = new ResourceLocation("watersource", "purification_strainers");

    public PurifiedWaterBagRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        boolean hasStrainer = false;
        boolean hasPotion = false;
        ItemStack strainer = ItemStack.field_190927_a;
        int potion = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            ITag tag = ItemTags.func_199903_a().func_199910_a(this.strainerTag);
            if (tag != null && tag.func_230235_a_((Object)itemstack.func_77973_b())) {
                list.add(itemstack);
                strainer = itemstack.func_77946_l();
                hasStrainer = true;
            }
            if (!(itemstack.func_77973_b() instanceof WaterBagItem) || !FluidHelper.isItemStackFluidEqual(itemstack, FluidHelper.fillContainer(new ItemStack((IItemProvider)ItemRegistry.WOODEN_CUP_DRINK), (Fluid)Fluids.field_204546_a))) continue;
            list.add(itemstack);
            potion = FluidUtil.getFluidHandler((ItemStack)itemstack).map(date -> date.getFluidInTank(0).getAmount()).orElse(0);
            hasPotion = true;
        }
        return hasPotion && hasStrainer && list.size() == 2 && potion != 0 && strainer.func_77958_k() - strainer.func_77952_i() >= potion / 250;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (!(itemstack.func_77973_b() instanceof WaterBagItem) || !FluidHelper.isItemStackFluidEqual(itemstack, FluidHelper.fillContainer(new ItemStack((IItemProvider)ItemRegistry.WOODEN_CUP_DRINK), (Fluid)Fluids.field_204546_a))) continue;
            ItemStack i = itemstack.func_77946_l();
            FluidUtil.getFluidHandler((ItemStack)i).ifPresent(data -> {
                int n = data.getFluidInTank(0).getAmount();
                data.drain(n, IFluidHandler.FluidAction.EXECUTE);
                data.fill(new FluidStack(this.fluid, n), IFluidHandler.FluidAction.EXECUTE);
            });
            return i;
        }
        return this.func_77571_b();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        ItemStack itemstack;
        int j;
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        int n = 0;
        for (j = 0; j < inv.func_70302_i_(); ++j) {
            itemstack = inv.func_70301_a(j);
            if (!(itemstack.func_77973_b() instanceof WaterBagItem) || !FluidHelper.isItemStackFluidEqual(itemstack, FluidHelper.fillContainer(new ItemStack((IItemProvider)ItemRegistry.WOODEN_CUP_DRINK), (Fluid)Fluids.field_204546_a))) continue;
            n = FluidUtil.getFluidHandler((ItemStack)itemstack).map(data -> data.getFluidInTank(0).getAmount()).orElse(0);
        }
        for (j = 0; j < inv.func_70302_i_(); ++j) {
            itemstack = inv.func_70301_a(j);
            ITag tag = ItemTags.func_199903_a().func_199910_a(this.strainerTag);
            if (itemstack.func_190926_b() || tag == null || !tag.func_230235_a_((Object)itemstack.func_77973_b())) continue;
            nonnulllist.set(j, (Object)StrainerBlockItem.damageItem(itemstack.func_77946_l(), n / 250));
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RecipeSerializersRegistry.CRAFTING_PURIFIED_WATER_BAG.get();
    }

    public ItemStack func_77571_b() {
        return FluidHelper.fillContainer(new ItemStack((IItemProvider)ItemRegistry.LEATHER_WATER_BAG), this.fluid);
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ItemRegistry.LEATHER_WATER_BAG)}));
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)BlockRegistry.ITEM_PAPER_STRAINER)}));
        list.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151034_e)}));
        return list;
    }
}

